//------------------------------------------------------------------------------
// File: client_tasklistener.cs
// This file contains TaskListener methods that allow for message handling on
// client side
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Called when the task listener receives a task dialog message
//! \param[in] %dlgData Dialog data object id
//! \param[in] %dlgObj Object, if any, tied to dialog
////////////////////////////////////////////////////////////////////////////////
function TaskListener::handleTaskDlgMsg(%this, %dlgData, %dlgObj)
{
   // Dialog attached to object first
   if(isObject(%dlgObj)) {
      // If on click push dialog
      if(%dlgData.onClickDlg) {
         pushTaskDlg(%dlgData, %dlgObj);
         %this.processNextMessage();
      }
      // Otherwise fire dialog
      else {
         populateTaskDlg(%dlgData, %dlgObj, true);
      }
      
   }
   // Immediately show dialog since there isn't an attached object (portrait
   // camera will not show)
   else {
      populateTaskDlg(%dlgData, %dlgObj, true);
   }
}

// End client_tasklistener.cs
